/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.client;

import com.mojang.authlib.GameProfile;
import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.api.util.GameProfileHelper;
import dev.upcraft.datasync.client.SessionStore;
import dev.upcraft.datasync.content.DataStore;
import dev.upcraft.datasync.net.S2CUpdatePlayerDataPacket;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class DataSyncModClient
implements ClientModInitializer {
    public static final SessionStore SESSION_STORE = new SessionStore();

    public static void preloadPlayerData() {
        if (!DataSyncMod.LOGIN_AUTOFETCH) {
            return;
        }
        GameProfile profile = class_310.method_1551().method_1548().method_1677();
        if (GameProfileHelper.isOfflineProfile(profile)) {
            DataSyncMod.LOGGER.debug("Offline player detected, not preloading player data");
            return;
        }
        DataStore.refresh(profile.getId(), DataSyncMod.LOGIN_FORCE_REFRESH).exceptionally(t -> {
            DataSyncMod.LOGGER.error("Unable to preload player data", t);
            return null;
        });
    }

    public static GameProfile getCurrentPlayerProfile() {
        return class_310.method_1551().method_1548().method_1677();
    }

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(S2CUpdatePlayerDataPacket.TYPE, S2CUpdatePlayerDataPacket::handle);
    }
}

